#!/usr/bin/env python3
"""Test script that checks if zlib was statically linked to executable"""
import subprocess
import sys

def handle_common(path):
    """Handle the common case."""
    output = subprocess.check_output(['nm', path]).decode('utf-8')
    if 'T zlibVersion' in output:
        return 0
    return 1

def handle_cygwin(path):
    """Handle the Cygwin case."""
    output = subprocess.check_output(['nm', path]).decode('utf-8')
    if 'I __imp_zlibVersion' in output:
        return 1
    return 0

def main():
    """Main function"""
    if len(sys.argv) > 2 and sys.argv[1] == '--platform=cygwin':
        return handle_cygwin(sys.argv[2])
    else:
        return handle_common(sys.argv[2])


if __name__ == '__main__':
    sys.exit(main())
